function lidar_proc=read_CSM(fid,declination)
fseek(fid,0,'eof');
dend=ftell(fid);
frewind(fid)
C=textscan(fid,'%s %s',1);
lidar_proc.orig_filename=C{1,2};
C=textscan(fid,'%s %s %d',1);
lidar_proc.system_id=C{1,3};
C=textscan(fid,'%s %s %s %d',1);
lidar_proc.number_of_gates=C{1,4};
C=textscan(fid,'%s %s %s %s %n',1);
lidar_proc.range_gate_length=C{1,5};
C=textscan(fid,'%s %s %s %d',1);
lidar_proc.gatelengthinpts=C{1,4};
C=textscan(fid,'%s %d',1);
lidar_proc.pulses_per_ray=C{1,2};
C=textscan(fid,'%s %s %s %s %s %n',1);
lidar_proc.number_of_waypoints=C{1,6};
C=textscan(fid,'%s %s %s %s %s %s %s ',1);
lidar_proc.scan_type=[C{1,3},C{1,4},C{1,5},C{1,6},C{1,7}];
C=textscan(fid,'%s %s %d',1);
lidar_proc.focus_range=C{1,3};
C=textscan(fid,'%s %s %s %s',1);
temp=[char(C{1,3}),' ',char(C{1,4})];
lidar_proc.start_time=datenum(char(temp),'yyyymmdd HH:MM:SS');
C=textscan(fid,'%s %s %n',1);
lidar_proc.resolution=C{1,3};
C=textscan(fid,'%s %s %s %s %s %s %s %s %s %s %s %s %s %s',1);
C=textscan(fid,'%s %s %s %s %s %s %s %s %s %s %s %s %s %s',1);
C=textscan(fid,'%s',1);
C=textscan(fid,'%s %s %s %s %s %s %s %s %s %s %s %s %s %s',1);
C=textscan(fid,'%s %s %s %s %s %s',1);
C=textscan(fid,'%s',1);
j=1;
nrays=0;
dloc=ftell(fid);
ernst=0;
j=0;
who=double(lidar_proc.number_of_gates-lidar_proc.gatelengthinpts);
if lidar_proc.number_of_gates>150
    lidar_proc.ranges=lidar_proc.range_gate_length/2+[0:lidar_proc.number_of_gates-lidar_proc.gatelengthinpts-1]*3;
else
    lidar_proc.ranges=lidar_proc.range_gate_length/2+[0:lidar_proc.number_of_gates-1]*lidar_proc.range_gate_length;
end
lidar_proc.ranges=double(lidar_proc.ranges);
AA=fscanf(fid,'%f %f %f',[5,1]);
AB=fscanf(fid,'%i %f %f %e',[4,who]);
[q,qq]=size(AB);
nr=qq;
status=fseek(fid,dloc,'bof');
while ernst==0
    j=j+1;
    AA=fscanf(fid,'%f %f %f %f %f',[5,1]);

    if ~isempty(AA)
        azimuth(j,1)=AA(2)+declination;
        elevation(j,1)=AA(3);
        [AB]=fscanf(fid,'%i %f %f %e',[4,who]);
        [q,qq]=size(AB);
        if isequal(qq,nr)
            lidar_proc.lidar_decimal_time(j)=AA(1);
%             lidar_proc.azimuth(j)=AA(2)+declination;
%             lidar_proc.elevation(j)=AA(3);
            tt=datevec(lidar_proc.start_time);
            t2=datevec(lidar_proc.lidar_decimal_time(j)/24);
            lidar_proc.timestamp(j)=datenum([tt(1) tt(2) tt(3) t2(4) t2(5) t2(6)]);
            lidar_proc.RWS(j,:)=AB(2,:);
            lidar_proc.SNR(j,:)=AB(3,:);
            lidar_proc.Beta(j,:)=AB(4,:);
            nrays=nrays+1;
            disp([num2str(ftell(fid)),' / ',num2str(dend)])
        else
            ernst=1;
        end

    else
        ernst=1;
    end
end
lidar_proc.number_of_rays=nrays;
[nn,nr]=size(lidar_proc.RWS);
for j=1:nr
    lidar_proc.azimuth(:,j)=azimuth;
    lidar_proc.elevation(:,j)=elevation;
end
lidar_proc.xd=(sin(azimuth*pi/180).*cos(elevation*pi/180))*double(lidar_proc.ranges);
lidar_proc.yd=(cos(azimuth*pi/180).*cos(elevation*pi/180))*double(lidar_proc.ranges);
lidar_proc.zd=(sin(elevation*pi/180))*double(lidar_proc.ranges);
return









